	function PLOT_IDEAL_IMPULSE_RESPONSE_Z(WcT, n0)
 	
	%	Plots the ideal impulse response, h(n) for a discrete-time filter
	%	between -n0 and n0. 
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB

	
	% Author: 			Lars Wanhammar 2005-11-14
	% Modified by: 	 	
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:		
	% Report bugs to:	lars.wanhammar@liu.se
	
	%========================================================	
	% Standard settings
	fs = 12; 		% Font size
	lw = 1; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	
	n0 = 60;
	WcT = pi/8;
	n = [-n0:1:n0];
	h_of_n = sin(WcT*n);
	nzero = find(n==0);
	n(nzero) = 1;
	h_of_n = h_of_n./(pi*n);
	%	stem(n,h_of_n,'k.-')
	%	xlabel('n'); ylabel('h(n)');
	
	linetype = '-';
	color = 'b';			% Set color
	x = [1:length(h_of_n)];
	x = x(:)';
    h_of_n = h_of_n(:)';
	xx = [x; x];
	yy = [zeros(1, length(x)); h_of_n];
	ax = newplot;	
	aym = max(abs(h_of_n))*0.1;
	plot(x, h_of_n, [color '.'], xx, yy, [color linetype],'linewidth', lw)
	stem(x, h_of_n,'filledd')
	color = 'k';
	set(get(ax,'xlabel'),'string','\itn','fontsize', fs,'fontname', fn)
	set(get(ax,'ylabel'),'string','Impulse response \ith}({\itn})','fontsize', fs,'fontname', fn)
	set(ax,'ylim',[min(h_of_n)-aym max(h_of_n)+aym], 'Ycolor', color, 'linewidth', lw, 'fontsize', fs, 'fontname', fn);
	set(ax,'xlim',[0 length(h_of_n)+1], 'Xcolor', color);
	box on;
	color = 'b';	
	grid on;
	
